
# (A1) データ分析基盤の構築と可視化

```mermaid
flowchart LR
    subgraph sakura[さくらのクラウド]
      vm[VM]
    end
    subgraph addon[Addon]
        datalake["Azure Data Lake Storage Gen2"]
        etl["Azure Data Factory"]
        dwh["Azure Synapse Analytics"]
        bi["Power BI"]
    end

    vm -- "データアップロード" --> datalake
    datalake -- "ロード" --> etl
    etl -- "データ変換" --> dwh
    bi -- "クエリ実行・可視化" --> dwh
```

## 各機能のサービス対応

| 機能 | 対応サービス |
| --- | --- |
| データレイク | Azure Data Lake Storage Gen2 |
| ETL/データ変換 | Azure Data Factory |
| DWH | Azure Synapse Analytics（専用SQLプール） |
| クエリ実行・可視化 | Power BI |

### 参考

- [Azure Data Lake Storage の概要](https://learn.microsoft.com/ja-jp/azure/storage/blobs/data-lake-storage-introduction)

- [Azure Data Factoryの概要](https://learn.microsoft.com/ja-jp/azure/data-factory/introduction)

- [チュートリアル: Azure Data Factory を使用して Azure BLOB ストレージから Azure SQL Database 内のデータベースにデータをコピーする](https://learn.microsoft.com/ja-jp/azure/data-factory/tutorial-copy-data-portal?source=recommendations)

- [Azure Synapse Analyticsの概要](https://learn.microsoft.com/ja-jp/azure/synapse-analytics/overview-what-is)

- [Azure SQL による Microsoft Entra 認証の構成と管理](https://learn.microsoft.com/ja-jp/azure/azure-sql/database/authentication-aad-configure?toc=%2Fazure%2Fsynapse-analytics%2Fsql-data-warehouse%2Ftoc.json&view=azuresql&tabs=azure-portal)

- [Power BI Desktop](https://www.microsoft.com/ja-jp/power-platform/products/power-bi/desktop?msockid=17af7dc3a15b686f0b886b83a0bc6934)

- [チュートリアル: Power BI Desktop でサーバーレス SQL プールを使用する > レポートを作成する](https://docs.azure.cn/en-us/synapse-analytics/sql/tutorial-connect-power-bi-desktop)