# (A2) データ保存内容の可視化

```mermaid
flowchart LR
      subgraph sakura[さくらのクラウド]
        sakura_storage["オブジェクトストレージ<br>(さくら)"]
      end
      subgraph azure[Addon]
        etl["Azure Data Factory"]
        datalake["Azure Data Lake <br>Storage Gen2"]
        query["Azure Synapse Analtycis"]
        bi["Power BI"]
      end

      sakura_storage -- "データアップロード" --> etl
      etl -- "変換" --> datalake
      query -- "クエリ実行" --> datalake
      bi -- "ログの検索と表示" --> query
```

## 各機能のサービス対応

| 機能 | 対応サービス |
| --- | --- |
| ETL/データ変換 | Azure Data Factory |
| データレイク | Azure Data Lake Storage Gen2 |
| クエリ機能 | Azure Synapse Analytics（専用SQLプール） |
| BI | Power BI |

### 参考

- [Azure Data Lake Storage の概要](https://learn.microsoft.com/ja-jp/azure/storage/blobs/data-lake-storage-introduction)

- [Azure Data Factoryの概要](https://learn.microsoft.com/ja-jp/azure/data-factory/introduction)

- [Azure Synapse Analyticsの概要](https://learn.microsoft.com/ja-jp/azure/synapse-analytics/overview-what-is)

- [Power BI Desktop](https://www.microsoft.com/ja-jp/power-platform/products/power-bi/desktop?msockid=17af7dc3a15b686f0b886b83a0bc6934)

- [Synapse SQL で外部テーブルを使用する](https://learn.microsoft.com/en-us/azure/synapse-analytics/sql/develop-tables-external-tables?tabs=hadoop#create-and-query-external-tables-from-a-file-in-azure-data-lake)

- [チュートリアル: Power BI Desktop でサーバーレス SQL プールを使用してレポートを作成する](https://learn.microsoft.com/ja-jp/azure/synapse-analytics/sql/tutorial-connect-power-bi-desktop)
