# (A4) 検索

```mermaid
flowchart LR
    subgraph sakura[さくらのクラウド]
      objectstorage[オブジェクトストレージ]
    end
    subgraph addon[Addon]
        datalake["Azure Data Lake<br />Storage Gen2"]
        etl["Azure Data Factory"]
        search["Azure AI Search"]
    end

    objectstorage -- "ロード" --> etl
    etl -- "データ変換" --> datalake
    datalake -- "インポート" --> search
```

## 各機能のサービス対応

| 機能 | 対応サービス |
| --- | --- |
| データレイク | Azure Data Lake Storage Gen2 |
| ETL/データ変換 | Azure Data Factory |
| 検索 | Azure AI Search |

### 参考

- [Azure Data Lake Storage の概要](https://learn.microsoft.com/ja-jp/azure/storage/blobs/data-lake-storage-introduction)

- [Azure Data Factory の概要](https://learn.microsoft.com/ja-jp/azure/data-factory/introduction)

- [Azure AI Search の概要](https://learn.microsoft.com/ja-jp/azure/search/search-what-is-azure-search)

- [Azure Data Factory または Azure Synapse Analytics を使用した Azure Data Lake Storage Gen2 でのデータのコピーと変換](https://learn.microsoft.com/ja-jp/azure/data-factory/connector-azure-data-lake-storage)

- [区切りテキスト解析モードを使用して CSV BLOB およびファイルにインデックスを作成する](https://learn.microsoft.com/ja-jp/azure/search/search-how-to-index-csv-blobs)

- [Azure Data Lake Storage Gen2 からのデータのインデックスを作成する](https://learn.microsoft.com/ja-jp/azure/search/search-howto-index-azure-data-lake-storage)
