# (A5) ストリーミング処理

```mermaid
flowchart LR
    subgraph sakura[さくらのクラウド]
      subgraph vm[VM]
        vm_nginx[Nginx]
        vm_fluent[Fluent Bit]
        vm_nginx -- "log" --> vm_fluent
      end
    end
    vm_fluent -- "Data Push" --> etl_input
    subgraph addon[Addon]
      etl_input["Azure Data Lake<br>Storage Gen2"]
      etl["Azure Data Factory"]
      etl_eventgrid["Azure Event Grid"]

      etl_input -- "イベント" --> etl_eventgrid -- "イベント" --> etl
      etl_input -- "ロード" --> etl

      etl_output["Azure Data Lake<br>Storage Gen2"]

      etl -- "保存" --> etl_output
      etl_output -- "Input" --> stream

      stream["Azure Stream Analytics"]
      stream_output["Azure Data Lake<br>Storage Gen2"]

      stream -- "Output" --> stream_output
    end
```

## 各機能のサービス対応

| 機能 | 対応サービス |
| --- | --- |
| データレイク | Azure Data Lake Storage Gen2 |
| ETL/データ変換 | Azure Data Factory |
| ストリーミング処理 | Azure Stream Analytics |
| イベント処理 | Azure Event Grid |

### Azure Stream Analyticsの可用性

Azure Stream Analyticsは、可用性ゾーン（Availability Zones）を活用した冗長構成に対応しており、ジョブは自動的に可用性ゾーンが適用されます。

詳細な内容は以下のリンクの記事を参照ください。

[Azure Stream Analytics の概要-[信頼性]](https://learn.microsoft.com/ja-jp/azure/stream-analytics/stream-analytics-introduction#reliability)  

### 参考

- [Azure Data Lake Storage の概要](https://learn.microsoft.com/ja-jp/azure/storage/blobs/data-lake-storage-introduction)

- [Azure Data Factory の概要](https://learn.microsoft.com/ja-jp/azure/data-factory/introduction)

- [Azure Stream Analytics の概要](https://learn.microsoft.com/ja-jp/azure/stream-analytics/stream-analytics-introduction)

- [Azure Event Grid の概要](https://learn.microsoft.com/ja-jp/azure/event-grid/overview)

- [Azure Data Factory または Azure Synapse Analytics を使用した Azure Data Lake Storage Gen2 でのデータのコピーと変換](https://learn.microsoft.com/ja-jp/azure/data-factory/connector-azure-data-lake-storage)

- [クイック スタート: Azure Portal を使用して Stream Analytics ジョブを作成する](https://learn.microsoft.com/ja-jp/azure/stream-analytics/stream-analytics-quick-create-portal)
