resource "random_id" "uid" {
  byte_length = 4
  keepers = {
    namespace = var.label.namespace
  }
}

module "label" {
  source     = "cloudposse/label/null"
  namespace  = var.label.namespace
  delimiter  = "-"
  attributes = ["${random_id.uid.hex}"]
}

data "sakuracloud_archive" "ubuntu" {
  os_type = "ubuntu"
}

module "label_server" {
  source  = "cloudposse/label/null"
  name    = "server"
  context = module.label.context
}

module "label_disk" {
  source     = "cloudposse/label/null"
  attributes = ["disk"]
  context    = module.label_server.context
}

resource "sakuracloud_disk" "disk" {
  name              = module.label_disk.id
  size              = var.disk_size
  plan              = var.disk_plan
  source_archive_id = data.sakuracloud_archive.ubuntu.id
}

resource "sakuracloud_server" "server" {
  name   = module.label_server.id
  core   = var.server_core
  memory = var.server_memory
  disks  = [sakuracloud_disk.disk.id]

  network_interface {
    upstream = "shared"
  }

  disk_edit_parameter {
    ssh_keys        = var.ssh_keys
    hostname        = module.label_server.id
    password        = var.server_password
    disable_pw_auth = true
  }
}