variable "label" {
  description = "ラベル生成のための設定値"
  type = object({
    namespace = string
  })
}

variable "server_core" {
  description = "Number of CPU cores"
  type        = number
  default     = 1
}

variable "server_memory" {
  description = "Amount of memory in GB"
  type        = number
  default     = 2
}

variable "disk_size" {
  description = "Size of the disk in GB"
  type        = number
  default     = 20
}

variable "disk_plan" {
  description = "Disk plan (e.g., ssd)"
  type        = string
  default     = "ssd"
}


variable "server_password" {
  description = "Password for Ubuntu server"
  type        = string
  sensitive   = true
    validation {
    condition     = length(var.server_password) >= 12 && length(regex("[A-Za-z0-9@$!%*?&]+", var.server_password)) > 0
    error_message = "パスワードは最低12文字で、大文字、小文字、数字、特殊文字をそれぞれ1つ以上含む必要があります。"
  }
}

variable "ssh_keys" {
  type        = list(string)
  description = "value of ssh_keys" 
}