variable "label" {
  description = "ラベル生成のための設定値"
  type = object({
    namespace = string
  })
  default = {
    namespace = "usecase-a6"
  }
}

variable "private_network" {
  type = object({
    gateway_ip = string
    netmask    = number
  })
  default = {
    gateway_ip = "192.168.0.1"
    netmask    = 24
  }
}

# VPN L2TP/IPsec設定
variable "vpn_l2tp_pre_shared_secret" {
  type      = string
  sensitive = true
}
variable "vpn_l2tp_range" {
  type = object({
    start = string
    stop  = string
  })
  default = {
    start = "192.168.0.200"
    stop  = "192.168.0.249"
  }
}

# VPNユーザー認証
variable "vpn_users" {
  type = list(object({
    name     = string
    password = string
  }))
  sensitive = true
}

# VPN FW
variable "vpn_firewall_source_network" {
  type = string
  default = "0.0.0.0"
}

# PostgreSQL
variable "postgres_user" {
  type = object({
    username = string
    password = string
  })
  sensitive = true
}
variable "postgres" {
  type = object({
    ip = string
  })
  default = {
    ip = "192.168.0.31"
  }
}
